/*******************************************
* Hello.c - Hello World Demo 
*******************************************/

#include <stdio.h>
#include <reg51.h>

void main(void){

	/**************************************************************************
	* If programmed to ROM/FLASH: 
	*
	* 1.) Set L51FLAGS to -r0 or -r0,XXXX (if external RAM is required. XXXX is 
	*     the start addresss of your RAM. For most of our wickenhaeuser boards
	*     this is $8000 (with 32 kB RAM))
	*
	* 2.) Don't forget to set up UART! (=COM1):
	*     Set up UART: Find the description in the CPU's User's manual!
	*     Not needed for this if downloaded to XRAM (COM1 already initialized)
	*     If using uC/51's interrupt driven serial IO (which is the default), enable 
	*     the serial interrupts FLAG (ES=1), if using the polled version (SIOTYPE=P
	*     in the makefile), don't enable it. You must include the appropriate register
	*     definition for the used microcontroller. Here are some examples:
	
	-----------------------------------------------------------------------------
	//9600 Bd. for a C515, running @ 12 MHz:
	#include <reg535.h>

	// Set up UART - Find the description in the User's manual!
	PCON |= 128;	// Baudrate double
	SCON = 124;	// 8 Bit UART - PC-compatible
	BD=1;		// 80C535 Baudrate 4800/9600 Bd @ 12MHz (un-/doubled)
	ES=1;		// Enable Serial IRQ (if required)
	EAL=1;		// Enable general IRQs (if required)
	-----------------------------------------------------------------------------

	-----------------------------------------------------------------------------
	//9600 Bd. for a generic 8051, running @ 11.0592 MHz:
	#include <reg51.h>

	// Set up UART - Find the description in the User's manual!
  	PCON|=128;	// Baudrate double
	SCON = 124;	// 8 Bit UART - PC-compatible
  	TH1=250; 	// Divisor= -6 (57600/6=9600 Bd.)
  	TMOD=32;	// use timer 1 as baudrate generator
  	TCON=64;		
	ES=1;		// Enable Serial IRQ (if required)
	EA= 1;		// Enable general IRQs (if required)
	-----------------------------------------------------------------------------
	***************************************************************************/

	//9600 Bd. for a generic 8051, running @ 11.0592 MHz:

	// Set up UART - Find the description in the User's manual!
  	PCON|=128;	// Baudrate double
	SCON = 124;	// 8 Bit UART - PC-compatible
  	TH1=255; 	// Divisor= -1 (57600/1=57600 Bd.)
  	TMOD=32;	// use timer 1 as baudrate generator
  	TCON=64;		
	ES=1;		// Enable Serial IRQ (if required)
	EA= 1;		// Enable general IRQs (if required)

	printf("Hello World\n");

	getc();		// Wait for a key to restart...
}