#####################################################################
#
# OS535.MAK: MAKEFILE for EPROM or an internal FLASH
#
# V1.02 2003 (C) Wickenhaeuser
#
# The FLASHMON (downloader) and SLD51 (Source level debugger) need
# this 'OS' to communicate and to download software to the RAM.
#
# OS515 may be used on ALMOST any generic 8051 and derivates
# if the system has some external memory, to download and run it:
#
# For this, the #PSEN and the #RD signal must be or-ed. We recommend
# to use the inverted address line A15 to enable the RAM (32kB)
# At code address $0000 this OS535.BIN must be set.
# Enable the 'A51FLAGS' to the type of used CPU and crystal!
# Read more about the required memory layout in the included manual
# of our MINI535 ('src\mini535\m535_v31.pdf').
# 
# Because OS535.BIN needs only a few kb, you can even put it into an
# single chip CPU, which has only external memory. With little
# modifications OS515 could get a non volatile user program from a 64kB
# serial Flash I2C-E2PROM, code could be written to it, by modifying
# the included Flashmon-driver ('src\flash\flashmon.c')...
# 
# Tested combinations and TYP:
# ============================
#
# C535/C515 @12 MHz (OS535 in EPROM): TYP=1: 9600 Bd
# C535/C515 @11.0592 MHz (-"-):       TYP=2: 57600 Bd.
# C515/C535 @22.1184 MHz (-"-):       TYP=3: 115200 Bd.
# 80C51 @11.0592 MHz (-"-)            TYP=2: 57600 Bd.
# C5525 @11.0592 MHz (-"-):           TYP=4: 57600 Bd.
# AT89C8252 @22.1184 Mhz (generic 8051, OS535 in the internal FLASH): TYP=3: 115200 Bd.
#
#
# ----------------------- SPECIAL OFFER: -----------------------------
#
# Interested in using OS535 on your commercial sold boards? We will happily
# allow you to use it for free(!!!), if you include (the free demo) uC/51 
# and/or related software products from us in your distribution.
#
# Please contact j.wickenh@wickenhaeuser.de for an agreement!
#
#
#
#######################################################################


# This is a typical minimum makefile:
#
# Set the variable TYP to according hardware (see OS552.S51)

L51FLAGS = -r0          # Fix to Eprom!
A51FLAGS = -aTYP=4 -g	# Type of CPU and crystal - see comments above
#A51FLAGS = -aTYP=2 -g	# Type of CPU and crystal - see comments above

OS552.BIN: OS552.s51
OS552.HEX: OS552.BIN	# write both: BIN and HEX files
